/*****************************************************************************/
/* FILE:     COPYFILE.CMD                                                    */
/* FUNCTION: RbCopy                                                          */
/*                                                                           */
/* Interactive file copying.  WARNING!  Target file will be destroyed.       */
/*                                                                           */
/* Requests to enter the source and target file names and options for RbCopy.*/
/* This allows to enter any of the options supported by the RbCopy           */
/* and is used to better understand how to use the RbCopy options.           */
/* See online information for details.                                       */
/*                                                                           */
/* RbCopy is executed with the specified options, then the source file       */
/* is appended to the target.  Next, RbCopy replaces the target file and     */
/* the last should fail because the target file exists and X option          */
/* was omitted.                                                              */
/*****************************************************************************/

/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
do until (trg <> '')
  say "Enter SourceFile TargetFile option(AXE)."
  parse upper pull src trg opt .
  end
say 'The target file "'trg'" will be destroyed!'
do until (ans = 'YES' | ans = 'NO')
  say 'To proceed and destroy the target file enter YES otherwise enter NO'
  parse upper pull ans .
  end
if ans='NO' then exit;
trace r
rc = RbCopy(src, "CON", E);  /* Type to screen discard EAs */
rc = RbCopy(src, trg, opt);  /* Copy with the options specified */
rc = RbCopy(src, trg, XA);   /* Will append to target       */
rc = RbCopy(src, trg, X);    /* Will replace target         */
rc = RbCopy(src, trg);       /* Should fail, target exists  */
