/*****************************************************************************/
/* FILE:     CRITSEC.CMD                                                     */
/* FUNCTION: RbEnterCritSec and RbExitCritSec                                */
/*                                                                           */
/* WARNING! After entering critical section no DLL calls should be performed.*/
/* OS/2 Critical section implementation can freeze the machine if a DLL is   */
/* called after critical section has been enter.  Use semaphores insted of   */
/* critical section whenever possible.  RexxBOS functions are implemented    */
/* as a DLL.  Calling RexxBOS function from critical section may cause       */
/* freezing the system.                                                      */
/*                                                                           */
/* This command file shows how entering the critical section can stop all    */
/* the threads of a process except one that has entered the critical section.*/
/*                                                                           */
/* This command is executed twice: in main thread and "child" thread.        */
/* The main thread starts the "child" thread using RbBeginThread.            */
/* The child thread enters critical section, displays first five lines       */
/* and exits the critical section.  When the child is in critical section    */
/* the main thread (parent) is not executed.  After child has exited the     */
/* critical section both threads are executed concurrently.                  */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
if (arg(1) = '') then do
  call RbBeginThread "CRITSEC.CMD child","RUN",'TID'
  do i=1 to 10
    say "<Parent>" i
    do j=1 to 400000; end; /* Can't call RbSleep.  Calling DLL */
    end                  /*  can block the process forever   */
  say Parent ended
  exit
  end

/************ Child ************/
call RbEnterCritSec
say "<Child> Critical section started"
do i=1 to 10
  if (i=5) then do
    say "<Child> Critical section ended"
    call RbExitCritSec
    end
  say "<Child>" i
  do j=1 to 400000; end; /* Could be a dll call like RbSleep(1000) */
  end                  /*  Should not block because the same     */
say child ended        /*   thread as EnterCritSec               */
