/*****************************************************************************/
/* FILE:     DUPHANDL.CMD                                                    */
/* FUNCTION: RbDupHandle                                                     */
/*                                                                           */
/* This command file uses RbDupHandle to redirect output of the DIR *.SYS    */
/* command to the specified file. The specified file information will be     */
/* destroyed.                                                                */
/*                                                                           */
/* RbQSysInfo and RbDiskN2C functions are used to issue DIR command against  */
/* the OS/2 boot drive's root directory.                                     */
/*                                                                           */
/* After DIR command output is recorded to the file the standard output      */
/* file is restored to screen (redirected back) so the last command          */
/* DIR *.INI displays the output information to the screen.                  */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
do until (filename <> '')
  say "Enter file name of the output file."
  parse upper pull filename
  end
say 'The file "'filename'" will be replaced!'
do until (ans = 'YES' | ans = 'NO')
  say 'To proceed and replace the file enter YES otherwise enter NO'
  parse upper pull ans .
  end
if ans='NO' then exit;
trace r
rc=RbOpen(filename, 'HF', 'CRTU');  /* Output file to redirect STDOUT to */
rc=RbDupHandle(Save, H1, 'HSTDOUT') /* Duplicate STDOUT handle "H1", save the*/
                                    /*  old STDOUT handle to restore later */
rc=RbDupHandle(Redirect, H1, HF)    /* Redirect STDOUT to file, Replace */
                                    /*  file handle by stdout           */
call RbQSysInfo("S");               /* Get system info including boot drive */
Root = RbDiskN2C(S.BootDriveNumber)":\" /* Boot drive root directory */
'DIR ' Root'*.sys'                  /* Will go to the file */
rc=RbClose(HF)                      /* Close file          */
rc=RbDupHandle(Redirect, H1, HSTDOUT);  /* Restore STDOUT to original */
'DIR ' Root'OS2\*.INI'             /* Will go to screen */
