/*****************************************************************************/
/* FILE:     EventSem.CMD                                                    */
/* FUNCTION: RbEventSem                                                      */
/*                                                                           */
/* When called without parameters this program creates an event semaphore in */
/* RESET state and start a separate session by 'Start EventSem WAIT'         */
/*                                                                           */
/* Then it allows to enter three lines and writes them to the file           */
/* C:\rexxbos.tmp and posts the semaphore.                                   */
/*                                                                           */
/* Second process opens semaphore and waits on it.  When the semaphore is    */
/* posted it displays the C:\rexxbos.tmp file.                               */
/*                                                                           */
/* This example presents a typical use of the event semaphore in the         */
/* client/supplier paradigm.  Supplier resets the semaphore and does not     */
/* post it till the data is ready.  Then it signals 'Data is ready' event    */
/* by posting the semaphore.  The consumer waiting on semaphore can use      */
/* data after semaphore has been posted.                                     */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

filename = 'C:\rexxbos.tmp'       /* Temporary file to be created */

/******************************************/
/* The first (main) process               */
/******************************************/
if (arg(1) <> 'WAIT') then do
  /******************************************/
  /* Create event semaphore and write file  */
  /******************************************/
  rc = RbEventSem("CREATE", "\SEM32\tevensem","Hev", "Reset");
  if (rc <> 0) then do
    Say 'Cannot create event semaphore \SEM32\tevensem'
    exit rc
    end
  'START EventSem WAIT'
  Say "The second process launched."
  call RbSleep  3000                      /* Give time to start session(3sec)*/
  call RbDelete filename                  /* Delete file */
  do i=1 to 3                             /* Allow       */
    say 'Enter line' i 'and hit enter'    /*  to         */
    pull line                             /*   enter     */
    call lineout filename, line           /*    three    */
    end                                   /*     lines   */
  call lineout filename                   /* And close the file */
  rc = RbEventSem('QUERY', Hev, "PostBefore")
  call RbEventSem "Post" ,Hev       /* Post the event semaphore */
  rc = RbEventSem('QUERY', Hev, "PostAfter")
  say "Post count Before post " PostBefore " and after " PostAfter
  call RbSleep 5000                 /* Give chance to run */
  call RbEventSem "CLose",Hev
  exit
  end

/******************************************/
/* The second session                     */
/******************************************/
say
/******************************************/
/* Open event semaphore and wait on it    */
/******************************************/
rc = RbEventSem("Open", "\SEM32\tevensem", "Hev");
if (rc <> 0) then do
  Say 'Cannot open event semaphore \SEM32\tevensem'
  exit rc
  end
rc = RbEventSem("WAIT", Hev, 120000); /*Wait for semaphore not more than 2min*/
if (rc <> 0) then do
  say 'Timed out'
  exit
  end
do i=1 to 3; l.i = linein(filename); end  /* Read the file */
call lineout filename                     /*  created in the first session */
say
say 'Here are the lines entered in the first window.'
do i=1 to 3; say l.i; end                 /* Display the lines */

call RbEventSem "CLose",Hev
exit
