/*****************************************************************************/
/* FILE:     EXATTRIB.CMD                                                    */
/* FUNCTION: RbEA  (extended attributes manipulation)                        */
/*                                                                           */
/* The command files shows how to use the RbEA function to manipulate        */
/* the  extended attributes on the file systems that support EAs.            */
/*                                                                           */
/* 1. First it requests a temporary file name that will be replaced with     */
/* new information.                                                          */
/* 2. All the extended attributes will be deleted from the file.             */
/* 3. Extended attributes .TYPE and .APPTYPE are added.                      */
/* 4. Extended attributes are queried.                                       */
/* 5. New EAs .CHECKSUM and .ASSOCTABLE are added                            */
/* 6. All EA values are queried.                                             */
/* 7. New values are assigned to EA .CHECKSUM and .ASSOCTABLE                */
/* 8. All EA values are queried.                                             */
/* 9. All EA are deleted.                                                    */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
filename = 'exattrib.dat'
say 'The test data file "'filename'" will be deleted!'
do until (ans = 'YES' | ans = 'NO')
  say 'To proceed and delete the file enter YES otherwise enter NO'
  parse upper pull ans .
  end
if ans='NO' then exit;

st.0 = 1; st.1 = 'text'; call RbWriteText filename, st /* Create file */
call RbEA D, filename   /* Delete all EAs */
/* Add extended attributes */
s.0 = 2
s.name.1='.TYPE';    s.type.1=65533;  s.value.1=10; s.count.1=10
s.name.2='.APPTYPE'; s.type.2=65534; s.value.2=4; s.count.2=4
say "Creating EA.  Rc=" RbEA(A, filename, s);
rc = RbEA(G, filename, s);
say "Getting EA.  Rc="rc
if rc=0 then do i=1 to s.0
 say s.name.i 'type='s.type.i 'attrlen='length(s.value.i) 'count='s.count.i
 end
say '__________________________________________________'
s.0 = 2
s.name.1='.CHECKSUM '; s.type.1=65534;  s.value.1=8; s.count.1=8
s.name.2='.ASSOCTABLE'; s.type.2=65503; s.value.2=8858; s.count.2=2
say "Adding  EA.  Rc=" RbEA(A, filename, s);
rc = RbEA(G, filename, s);
say "Getting EA.  Rc="rc
if rc=0 then do i=1 to s.0
 say s.name.i 'type='s.type.i 'attrlen='length(s.value.i) 'count='s.count.i
 end
say '__________________________________________________'
say 'REPLACING EAs .CHECKSUM and .ASSOCTABLE by new values'
s.0 = 2
s.name.1='.CHECKSUM '; s.type.1=7777;  s.value.1=1; s.count.1=7
s.name.2='.ASSOCTABLE'; s.type.2=9999; s.value.2=1; s.count.2=9
say "Adding  EA.  Rc=" RbEA(A, filename, s);
rc = RbEA(G, filename, s);
say "Getting EA.  Rc="rc
if rc=0 then do i=1 to s.0
 say s.name.i 'type='s.type.i 'attrlen='length(s.value.i) 'count='s.count.i
 end
say '__________________________________________________'
say "Deleting EA.  Rc=" RbEA(D, filename);
rc = RbEA(G, filename, s);
say "Getting EA.  Rc="rc
if rc=0 then do i=1 to s.0
 say s.name.i 'type='s.type.i 'attrlen='length(s.value.i) 'count='s.count.i
 end
