/*****************************************************************************/
/* FILE:     EXECPGM.CMD                                                     */
/* FUNCTION: RbExecPgm                                                       */
/*                                                                           */
/* RbExecPgm allows to launch processes.  EXE files can be launched directly */
/* while rexx command files should be launched using command processor       */
/* CMD.EXE or other launcher (an executable program).                        */
/*                                                                           */
/* RbQSysInfo and RbDiskN2C are used to determine the boot drive root dir.   */
/*                                                                           */
/* RbExec in this command file launches ATTRIB.EXE in synchronous and        */
/* different asynchronous modes.  RbWaitChild function allows to analyze     */
/* the completion codes of an asynchronous child process.                    */
/*                                                                           */
/* Asynchronous processes are executed concurrently and their output         */
/* interleaves.  Pay attention to the file extensions displayed.             */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

call RbQSysInfo("S");               /* Get system info including boot drive */
Root = RbDiskN2C(S.BootDriveNumber)":\" /* Boot drive root directory */

say '********* Synchronous. First all EXE ***************'
call RbExecPgm "ATTRIB.EXE" Root"OS2\*A*.EXE", Ret, 0        /* Synchronous */
say '********* Synchronous. Then all DLL ***************'
call RbExecPgm "ATTRIB.EXE" Root"OS2\DLL\*A*.DLL", Ret, 0    /*  execution  */
say 'Parent process'

say '********* Asynchronous 1 ALL EXE(Child1) DLL(Child2,3) INI(Parent) *******'
call RbExecPgm "ATTRIB.EXE" Root"OS2\*.EXE", Ret, 1           /* Asynchronous */
say 'Process ' Ret.PID started
call RbExecPgm "ATTRIB.EXE" Root"OS2\DLL\*A*.DLL", Ret, 1     /*   execution  */
say 'Process ' Ret.PID started
call RbExecPgm "ATTRIB.EXE" Root"OS2\DLL\*E*.DLL", Ret, 1     /*   execution  */
say 'Process ' Ret.PID started
"ATTRIB.EXE" Root"OS2\*.INI /S"

say '********* Asynchronous 2 ***************'
call RbExecPgm "ATTRIB.EXE" Root"OS2\*A*.EXE", Ret, 2       /* Asynchronous */
call RbWaitChild Ret.PID, Res                             /*  and wait completion */
say "********* Parent process continues *********"
say "TermCode = " res.termcode "Result = "res.rescode

