/*****************************************************************************/
/* FILE:     EXITPROC.CMD                                                    */
/* FUNCTION: RbExit                                                          */
/*                                                                           */
/* RbExit allows to exit a thread (if it is not the main thread) or the      */
/* process.                                                                  */
/* The main thread launches the second thread (same command file with        */
/* the parameter "CHILD") and waits to let the second thread run.            */
/* The second thread uses RbExit to terminate itself and the main thread     */
/* as well.  Exit would terminate just the second thread.                    */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
if (arg(1) = '') then do /* Main thread */
  rc = RbBeginThread("EXITPROC.CMD child","RUN", 'TID');
  if (rc <> 0) then do
    say 'Main: Error starting thread'
    exit
    end
  say 'Main: The second thread TID='TID 'has been started.'
  call RbSleep 8000
  say "Main: Should not come hear because the child thread exits the process"
  exit;
  end

/******************************************/
/* Second thread                          */
/******************************************/
say 'The 2nd thread exits the process terminating the main thread'
  call RbSleep 2000
  call RbExit  Process, 28
  end
