/*****************************************************************************/
/* FILE:     FILEPTR.CMD                                                     */
/* FUNCTION: RbOpen, RbWrite, RbRead, RbFilePtr                              */
/*                                                                           */
/* Shows how to use RbFilePtr to reposition file pointer for reading and     */
/* and writing.                                                              */
/*                                                                           */
/* 1. A file is created or updated with new information.                     */
/* 2. File pointer position is queried and then repositioned to the offset 5 */
/* 3. The file pointer position is queried and displayed and then            */
/* 4. File is read starting at the new file pointer position.                */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

do until (filename <> '')
  say "Enter file name to write."
  parse upper pull filename
  end
say 'The file "'filename'" will be replaced!'
do until (ans = 'YES' | ans = 'NO')
  say 'To proceed and delete the file enter YES otherwise enter NO'
  parse upper pull ans .
  end
if ans='NO' then exit;

rc=RbOpen(filename, 'h', 'COTU');
if (rc <> 0) then exit rc

rc = RbWrite(h, "0123456789");
if (rc <> 0) then exit rc;

call RbFilePtr Query, h, 'Fpos'
say 'File offset = ' Fpos


say 'Reposition at offset=5'
call RbFilePtr Begin, h, 5

call RbFilePtr Query, h, 'Fpos'
say 'File offset = ' Fpos


call RbRead h, 'Data', 3
say 'Data at offset 5-7 =' Data

call RbClose h

