/*******************************************************/
/* FILE:     GLISTBOX.CMD                              */
/* FUNCTION: RgListBox                                 */
/*                                                     */
/* Display single and multiple selection list boxes    */
/*******************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

select

/********************************************************/
/* Default variable name, default 1st elem selected     */
/********************************************************/
when arg(1) = '' then do                  /* Simplest single */
  rc = RgArrayFromStr('State.value', ' MD CA MA NY');
  rc = RgListBox(State, Single);
  end
/********************************************************/
/* Default variable name, 1st and 3rd elements selected */
/********************************************************/
when arg(1) = '1' then do                  /* Simple multiple */
  rc = RgArrayFromStr('State.value', ' MD CA MA NY');
  rc = RgArrayFromStr('State.select', ' 1 0 1 0');
  rc = RgListBox(State, Multiple);
  end
/********************************************************/
/* Everything explicitly specified for single selection */
/********************************************************/
when arg(1) = '2' then do
  rc = RgArrayFromStr('State.value', ' MD CA MA NY');
  State.size = 1                          /* One line size */
  State.Attr = E                          /* <em> attribute */
  rc = RgListBox(State, Single, vSt, 2); /* VarName = vSt, second element sel */
  end
/**********************************************************/
/* Everything explicitly specified for multiple selection */
/**********************************************************/
when arg(1) = '3' then do
  State.0 = 4;
  State.value.1='MD';State.value.2='CA';State.value.3='MA';State.value.4='NY'
  State.size = 2                          /* Two lines size */
  State.Attr = 1                          /* <h1> attribute */
  State.select.4=1                        /* Last selected */
  rc = RgListBox(State, Multiple, vSt); /* VarName = vSt */
  end
otherwise
  nop;
end
