/*******************************************************/
/* FILE:     GRADCHK.CMD                               */
/* FUNCTION: RgRadioCheck                              */
/*                                                     */
/* Display radio or check box                          */
/*******************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

select

/********************************************************/
/* Simplest checkboxes located in multiple lines (vert) */
/********************************************************/
when arg(1) = '' then do                  /* Nothing checked */
  rc = RgArrayFromStr('State.label', '.MD.CA.MA.NY');
  rc = RgRadioCheck(State, Check, Vertical);
  end
/***********************************************************************/
/* Simplest radio buttons in one line (horiz) default 1st checked      */
/***********************************************************************/
when arg(1) = '1' then do                  /* Simple multiple */
  rc = RgArrayFromStr('State.label', ' MD CA MA NY');
  rc = RgRadioCheck(State, Radio, Horiz);
  end
/*************************************************/
/* Everything explicitly specified for check box */
/*************************************************/
when arg(1) = '2' then do
  rc = RgArrayFromStr('State.label', ' MD CA MA NY');
  rc = RgArrayFromStr('State.varname', '/StA/StB/StC/StD'); /* Variable names */
  State.checked.1 = 1; State.checked.2 = 1; /* First two checked */
  State.Attr = E                          /* <em> attribute */
  rc = RgRadioCheck(State, Check, Vert);
  end

/****************************************************/
/* Everything explicitly specified for radio button */
/****************************************************/
when arg(1) = '3' then do
  rc = RgArrayFromStr('State.label', ' MD CA MA NY');
  State.varname = 'StName';               /* Just One for Radio button */
  State.Attr = 1                          /* <h1> attribute */
  rc = RgRadioCheck(State, Radio, Vert, 4); /* Last checked */
  end
otherwise
  nop
end
