/*******************************************************/
/* FILE:     GSTARDOC.CMD                              */
/* FUNCTION: RgStartDoc and RgEndDoc                   */
/*                                                     */
/* Display HTML prologue and epilogue                  */
/*******************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

select

/***************************************/
/* Minimum, no header no debugging     */
/***************************************/
when arg(1) = '' then do
  rc = RgStartDoc('Title Only');
  call RgEndDoc
  end
/***************************************/
/* Title and header <h2>               */
/***************************************/
when arg(1) = '1' then do
  rc = RgStartDoc('Title and Header', 2);
  call RgEndDoc
  end
/***************************************/
/* Title and debugging                 */
/***************************************/
when arg(1) = '2' then do
  rc = RgStartDoc('Title and Debug', D);
  call RgEndDoc
  end
/***************/
/* Empty title */
/***************/
when arg(1) = '3' then do
  rc = RgStartDoc('', '');
  call RgEndDoc
  end
/***************************************/
/* Header and form                     */
/***************************************/
when arg(1) = '4' then do
  rc = RgStartDoc('Title and Form', '2', "/cgi-bin/somescript.cmd");
  call RgEndDoc "Enter", "Reset"
  end
/************************************************/
/* Header and form no reset, next button only   */
/************************************************/
when arg(1) = '5' then do
  rc = RgStartDoc('Title and Form', , "/cgi-bin/somescript.cmd");
  call RgEndDoc "Next"
  end
/***********************************************************/
/* Title only (incorrect second parameter will be ignored) */
/***********************************************************/
when arg(1) = '6' then do
  rc = RgStartDoc('Title and IncorrectParameter', IncorrectParm);
  call RgEndDoc
  end
otherwise
  nop;
end
