/*******************************************************/
/* FILE:     GVARVAL.CMD                               */
/* FUNCTION: RgGetFormVarValue                         */
/*                                                     */
/* Get Request variable value by name                  */
/*******************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

/******************************************/
/* Simulate environment                   */
/******************************************/
env='OS2ENVIRONMENT'
call value 'REQUEST_METHOD','GET',env
call value 'QUERY_STRING','FNAME=Barry&MNAME=',env
rc = RgGetForm(ReqVar, EnvVar);
say '****** Request Variables ********'
fname=RgGetFormVarValue(ReqVar,"FNAME",'FoundFname')
mname=RgGetFormVarValue(ReqVar,"MNAME",'FoundMname')
lname=RgGetFormVarValue(ReqVar,"LNAME",'FoundLname')

say fname FoundFname              /* Should be 'Barry 1' (found) */
say mname FoundMname              /* Should be ' 1' (empty but found) */
say lname FoundLname              /* Should be ' 0' (empty and not found) */
