/*******************************************************/
/* FILE:     HLISTBOX.CMD                              */
/*                                                     */
/* Display list boxes                                  */
/*******************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

call RgStartDoc "List Boxes", 2

say '<p>'
say '<FORM METHOD="POST" ACTION="/cgi-bin/hvars.cmd">'

 /********************************************************/
 /* Default variable name, 1st and 3rd elements selected */
 /********************************************************/
   rc = RgArrayFromStr('St.value', ' MD CA MA NY');
   rc = RgArrayFromStr('St.select', ' 1 0 1 0');
   rc = RgListBox(St, Multiple);
   say '<hr>'
 /********************************************************/
 /* Default variable name, default 1st elem selected     */
 /********************************************************/
   rc = RgArrayFromStr('Sta.value', ' MD CA MA NY');
   rc = RgListBox(Sta, Single);
   say '<hr>'
 /********************************************************/
 /* Everything explicitly specified for single selection */
 /********************************************************/
   rc = RgArrayFromStr('State.value', ' MD CA MA NY');
   State.size = 1                          /* One line size */
   State.Attr = E                          /* <em> attribute */
   rc = RgListBox(State, Single, vSt3, 2); /* VarName = vSt, second element sel */
   say '<hr>'
 /**********************************************************/
 /* Everything explicitly specified for multiple selection */
 /**********************************************************/
   State.0 = 4;
   State.value.1='MD';State.value.2='CA';State.value.3='MA';State.value.4='NY'
   State.size = 2                          /* Two lines size */
   State.Attr = 1                          /* <h1> attribute */
   State.select.1=0
   State.select.2=0
   State.select.3=0
   State.select.4=0
   State.select.4=1                        /* Last selected */
   rc = RgListBox(State, Multiple, vSt4); /* VarName = vSt4 */
   say '<hr>'

say '<p><INPUT TYPE="SUBMIT" VALUE="Enter">'

say "</BODY></HTML>"
