/*******************************************************/
/* FILE:     HVARS.CMD                                 */
/*                                                     */
/* Display request and environment variables           */
/*******************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

call RgStartDoc "Variables From The Form", 2

 rc = RgGetForm(ReqVar, EnvVar);

 say '<h3>Request Variables</h3>'

tab.rows=ReqVar.0+1
tab.cols=2
tab.attrRow1=E
tab.1.1='Variable Name'
tab.1.2='Variable Value'
do i=1 to ReqVar.0                        /* Iterate variables */
  ti=i+1                                  /* Table row */
  tab.ti.1 = ReqVar.name.i
  tab.ti.2 = ReqVar.value.i
  end
call RgTable tab, Border


call RgArrayFromStr 'evar',' AUTH_TYPE CONTENT_LENGTH CONTENT_TYPE',
'GATEWAY_INTERFACE HTTP_ACCEPT HTTP_USER_AGENT PATH_INFO PATH_TRANSLATED',
'QUERY_STRING REMOTE_ADDR REMOTE_HOST REMOTE_IDENT REMOTE_USER',
'REQUEST_METHOD SCRIPT_NAME SERVER_NAME SERVER_PORT SERVER_PROTOCOL',
'SERVER_SOFTWARE'

 say '<h3>Request Environment Variables</h3>'

t.rows=20
t.cols=2
t.attrRow1=E
t.1.1='Environment Variable Name'
t.1.2='Variable Value'
do i=1 to evar.0                          /* Iterate environment vars */
  ti=i+1                                  /* Table row */
  t.ti.1 = evar.i
  end

t.2.2= EnvVar.AUTH_TYPE
t.3.2= EnvVar.CONTENT_LENGTH
t.4.2= EnvVar.CONTENT_TYPE
t.5.2= EnvVar.GATEWAY_INTERFACE
t.6.2= EnvVar.HTTP_ACCEPT
t.7.2= EnvVar.HTTP_USER_AGENT
t.8.2= EnvVar.PATH_INFO
t.9.2 = EnvVar.PATH_TRANSLATED
t.10.2 = EnvVar.QUERY_STRING
t.11.2 = EnvVar.REMOTE_ADDR
t.12.2 = EnvVar.REMOTE_HOST
t.13.2 = EnvVar.REMOTE_IDENT
t.14.2 = EnvVar.REMOTE_USER
t.15.2 = EnvVar.REQUEST_METHOD
t.16.2 = EnvVar.SCRIPT_NAME
t.17.2 = EnvVar.SERVER_NAME
t.18.2 = EnvVar.SERVER_PORT
t.19.2 = EnvVar.SERVER_PROTOCOL
t.20.2 = EnvVar.SERVER_SOFTWARE

call RgTable t, Border

say  EnvVar.SERVER_SOFTWARE

say "</BODY></HTML>"
