/*****************************************************************************/
/* FILE:     KBGETCHR.CMD                                                    */
/* FUNCTION: RkGetChar                                                       */
/*                                                                           */
/* Enters infinite loop checking if there is a character in the keyboard     */
/* buffer.  RkGetChar(Immediate, OutStem) does not wait and returns          */
/* immediately whether a character has been typed or not.                    */
/* After 10  characters has been entered it leaves the loop.                 */
/*                                                                           */
/* Then it peeks characters once a second without removing them.             */
/* Finally it waits for each next character to be entered (parm "W").        */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
i=0

do while (i<10)
rc=RkGetChar(Immediate, OutStem)
if (OutStem.Empty == 0) then do;
  rc=RvTTY(OutStem.Char||OutStem.Char);
  i = i+1;
  end
end

say 'Peeking 1 character per second'
do while (i<20)
call RbSleep 1000
rc=RkGetChar(N, OutStem)
rc=RvTTY(OutStem.Char, 72)
i = i+1
end

do while (i<30)
rc=RkGetChar(W, OutStem)
rc=RvTTY(OutStem.Char, 125);
i = i+1;
end
rc=RbSleep(1000);
