/*************************************************************************/
/* FILE:     KILLPROC.CMD                                                */
/* FUNCTION: RbKillProcess                                               */
/*                                                                       */
/* This command file is called three times: in main process without      */
/* an argument, and then launched from the main process and its child    */
/* using the command interpreter CMD.EXE with parm 1 and 2 accordingly.  */
/*                                                                       */
/* 1. Launch child process using  RbExecPgm "CMD.EXE /c KILLPROC 1"      */
/* 2. The child process launches in turn it's own child                  */
/*    using RbExecPgm "CMD.EXE /c KILLPROC 2"                            */
/* 3. Both children are suspended for 20 seconds and the user should     */
/*    quickly enter if he or she wants to kill a single process          */
/*    or the whole process tree.                                         */
/* 4. The child process 1 or the whole process tree is killed depending  */
/*    on the user response.                                              */
/* NOTE!  Please wait approximately 20 seconds till the parent process   */
/*        ends.                                                          */
/*************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

if (arg(1) = '') then  do
  call RbExecPgm "CMD.EXE /c KILLPROC 1", ret1, 1
  say "Started Pid1 = " ret1.PID
  end

if (arg(1) = 1) then do
  call RbExecPgm "CMD.EXE /c KILLPROC 2", ret2, 1
  say "Started Pid2 = " ret2.PID
  call RbSleep 20000
  say 'Exiting child process <1>'
  exit
  end

if (arg(1) = 2) then do
  call RbSleep 20000
  say 'Exiting grandchild process <2>'
  exit
  end

call RbSleep 3000
do while (ans <> 0 & ans <> 1)
  say Enter 0 to kill the whole process tree or 1 to kill the process only
  pull ans .
  end
if (ans = 0) then say 'Killing the process tree: process' ret1.pid "and  it's child"
  else do
    say 'Killing the immediate child only ' ret1.pid
    say 'Please wait, the grandchild proces is still running'
    end
say 'Killing process Rc = ' RbKillProcess(ans, ret1.pid);
call RbSleep 30000
say 'Exiting parent process.'
