/*****************************************************************************/
/* FILE:     MMGETNUM.CMD                                                    */
/* FUNCTION: RmGetNum                                                        */
/*                                                                           */
/* RmGetNum returns the number of mouse buttons, number of mickeys in each   */
/* centimeter, current and maximum number of the mouse event queue elements. */
/*                                                                           */
/* Opens the mouse handle first.  Must be always done.                       */
/* Suspends execution allowing user to move mouse and click buttons to       */
/* generate some events.  Displays the events and mouse configuration info.  */
/*                                                                           */
/* Then if flushes all the events from the mouse queue and demonstrates      */
/* that no events left in the queue.                                         */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
rc = RmOpen('h')
say 'Move mouse and click buttons for 2 seconds'
call RbSleep 2000
rc = RmGetNum(h,s)
say Buttons Mickeys Events MaxEvents
say s.Buttons s.Mickeys s.Events s.MaxEvents
rc = RmGetNum(h,s)
say 'Flushing event queue '
call RbSleep 1000
call RmFlushQue h
rc = RmGetNum(h,s)
say Buttons Mickeys Events MaxEvents
say s.Buttons s.Mickeys s.Events s.MaxEvents
rc = RmClose(h);
