/*****************************************************************************/
/* FILE:     MMSCALE.CMD                                                     */
/* FUNCTION: RmGetScale, RmSetScale                                          */
/*                                                                           */
/*    NOTE: Set scale factor works only in  full screen mode                 */
/*                                                                           */
/* Opens mouse handle first.                                                 */
/* Obtains and displays mouse scaling factor - the number of mikeys the mouse*/
/* must travel horizontally or vertically in order to cause OS/2 to move     */
/* the mouse pointer one screen unit.                                        */
/* Then it sets a new scale RowScale = 2 and ColScale = 3                    */
/* Displays the new scale and finally restores the scale to default 1,1      */
/*****************************************************************************/

/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
say 'RmGetScale and RmSetScale ARE SUPPORTED IN FULL SCREEN ONLY!!!'
call RbSleep 2000
rc = RmOpen('h')                          /* Open mouse handle */
rc = RmDrawPtr(h)                         /* Draw mouse pointer */
say 'Try to move the mouse pointer around.'
rc = RmGetScale(h,s)                      /* Get the scale and */
say s.RowScale s.ColScale                 /*  display it       */
call RbSleep 5000
rc = RmSetScale(h,1,4)                    /* Set RowScale to 1 and Col to 4 */
rc = RmGetScale(h,s)                      /* Get the new scale and */
say s.RowScale s.ColScale                 /*  display it           */
call RbSleep 5000
rc = RmSetScale(h,4,1)                    /* Set RowScale to 4 and Col to 1 */
rc = RmGetScale(h,s)                      /* Get the new scale and */
say s.RowScale s.ColScale                 /*  display it           */
call RbSleep 5000
rc = RmClose(h);                          /* Close the mouse handle   */
