/*****************************************************************************/
/* FILE:     MMSTATUS.CMD                                                    */
/* FUNCTION: RmGetStatus and RmSetStatus                                     */
/*                                                                           */
/* NOTE: SetStatus works only in FullScreen mode.                            */
/*                                                                           */
/* Demonstrates how to obtain and set mouse status in the Full Screen mode.  */
/*                                                                           */
/* Open the mouse handle first                                               */
/* Get mouse status and display it.                                          */
/* Set drawing and mickeys/pels ON/OFF                                       */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
say 'RmGetStatus and RmSetStatus ARE SUPPORTED IN FULL SCREEN ONLY!!!'
call RbSleep 2000
rc = RmOpen('h')
rc = RmGetStatus(h,s)
trace r
say s.QUEUEBUSY s.BLOCKREAD s.FLUSH s.UNSUPPORTED s.DISABLED s.MICKEYS
rc = RmSetStatus(h,"")
rc = RmGetStatus(h,s)
say s.DISABLED s.MICKEYS
rc = RmSetStatus(h,"DM")
rc = RmGetStatus(h,s)
say s.DISABLED s.MICKEYS
rc = RmSetStatus(h,"M")
rc = RmClose(h);
