/*****************************************************************************/
/* FILE:     MutexSem.CMD                                                    */
/* FUNCTION: RbMutexSem                                                      */
/*                                                                           */
/* When called without parameters this program creates a mutex semaphore in  */
/* UnOwned state and starts a separate session with the CHILD parameter      */
/*                                                                           */
/* Then it request the semaphore and when the semaphore ownership is         */
/* granted user can enter QUIT to close semaphore and exit or any other      */
/* line to release the semaphore.                                            */
/*                                                                           */
/* Second process opens semaphore and does the same.  So execution of the    */
/* threads is synchronized so one thread is running and another is waiting.  */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
address cmd
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

parse upper arg parm .

/******************************************/
/* Parent part                            */
/******************************************/
if (parm <> "CHILD") then do
  rc = RbMutexSem("CReate","\sem32\11111","HMUX",0); /* Create unowned */
  if (rc <> 0) then do
    say 'Cannot create the mutex semaphore RC=' rc
    exit
    end
  say 'Semaphore created.  Starting second session ...'
  rc = RbStartSes("cmd.exe /c" RbQCurrDir(RbQCurrDisk())"\mutexsem CHILD",,
                  'SessId', 2, 2);


  if (rc = 0) then Say 'SessId='SessId 'started'
  else say 'Cannot start session Rc='rc

  call RequestLoop
  exit
  end

/******************************************/
/* Child process part                     */
/******************************************/
address cmd
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
rc = RbMutexSem("OPEN","\sem32\11111","HMUX")
if (rc <> 0) then do
  say 'Cannot open the mutex semaphore RC=' rc
  exit
  end

call RequestLoop;
exit;

/*********************************************************/
/* Common part for two processes:                        */
/* juggle the execution using the mutex semaphore        */
/*********************************************************/
RequestLoop:
do forever
  call RbMutexSem "Query", hmux, stem
  if (stem.count = 0) then say 'No thread ownes the semaphore'
  else say 'Semaphore is owned by pid='stem.pid 'tid='stem.tid,
      'ReuestCount='stem.count
  say 'Requesting event semaphore ...'
  rc = RbMutexSem("REQ",hmux);
  if (rc = 0) then say 'Semaphore ownership granted.'
  else say 'Error requesting the semaphore hmux='hmux 'rc='rc

  say 'Enter QUIT to exit or any other string to release the semaphore.'
  parse upper pull ans
  call RbMutexSem "REL", hmux
  say 'Semaphore has been released.'
  if (ans = 'QUIT') then do
    call RbMutexSem "CLose", hmux
    leave
    end
  end
return
