/*****************************************************************************/
/* FILE:     MUXWSEM.CMD                                                     */
/* FUNCTION: RbMuxWaitSem                                                    */
/*                                                                           */
/* When called without parameters this program creates two mutex semaphores  */
/* in the unowned state and starts the second session specifying CHILD as    */
/* the only parameter.                                                       */
/*                                                                           */
/* Then it creates a muxwait semaphore comprised of two muxwait semaphore    */
/* and waits for any one to be released.  It uses query to determine         */
/* which one was released.                                                   */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
address cmd
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
parse upper arg parm .
if (parm <> "CHILD") then do
  rc1 = RbMutexSem("CReate","\sem32\11",'hmux1', 0);
  rc2 = RbMutexSem("CReate","\sem32\22",'hmux2', 0);
  if (rc1 <> 0 | rc2 <> 0) then do;
    say 'Cannot create mutex semaphore'
    exit
    end
  /* Start child and give it time to run */
  rc = RbStartSes("cmd.exe /c" RbQCurrDir(RbQCurrDisk())"\muxwsem CHILD",,
                  'SessId', 2, 2);

  if (rc = 0) then Say 'SessId='SessId 'started'
  else say 'Cannot start session Rc='rc

  call RbSleep 1000

  sems.0=1;             /* muxwait comprises just one muxwait first */
  sems.1=hmux1
  rc1 = RbMuxWaitSem("CReate","\sem32\33", 'hmuxw', sems, "One");
  call RbMuxWaitSem "Q", hmuxw, ret
  say 'Muxwait contains' ret.count 'element(s) and has' ret.attr 'attribute.'
  rc2 = RbMuxWaitSem("Add", hmuxw, hmux2);  /* add another to muxwait */
  call RbMuxWaitSem "Q", hmuxw, ret
  say 'Muxwait contains' ret.count 'elements now.'

  say 'Waiting ...'
  rc = RbMuxWaitSem('Wait', hmuxw, 'User');
  say 'Got it.  Rc = ' rc 'The semaphore #'user 'was released.'

  /******************************************/
  /* Release the semaphore now              */
  /******************************************/
  if (user = 1) then rc1 = RbMutexSem("REL",hmux1);
  else rc1 = RbMutexSem("REL",hmux2);
  call RbSleep 5000
  call  RbMuxWaitSem "CL",hmuxw
  call  RbMutexSem "CL", hmux1
  call  RbMutexSem "CL", hmux2
  exit
  end

say '2 Requesting mutex semaphore ...'
rc1 = RbMutexSem("OP","\sem32\11", 'hm1');
rc2 = RbMutexSem("OP","\sem32\22", 'hm2');
if (rc1 <> 0 || rc2 <> 0) then do
  say 'Cannot open semaphore(s) rc1='rc1 'rc2='rc2
  exit
  end
call RbMutexSem "REQ", hm1
call RbMutexSem "REQ", hm2
say 'Which to release first? Enter 1 or 2'
pull ans .
if (ans = 1) then do
  say 'Releasing 1st and then 2nd'
  call RbMutexSem "REL", hm1
  call RbSleep 200
  call RbMutexSem "REL", hm2
  end
else do
  say 'Releasing 2nd and then 1st'
  call RbMutexSem "REL", hm2
  call RbSleep 200
  call RbMutexSem "REL", hm1
  end
call RbMutexSem "CL", hm1
call RbMutexSem "CLose", hm2
exit
