/*****************************************************************************/
/* FILE:     NAMEPIPE.CMD                                                    */
/* FUNCTION: RbNPipe                                                         */
/*                                                                           */
/* Using named pipes.                                                        */
/*                                                                           */
/* This cmd is launched twice: by a user from the command line and           */
/* then it launches its child process, executing the same cmd                */
/* RbExecPgm("cmd.exe /c namepipe child ")                                   */
/*                                                                           */
/* The main (parent) process creates the named pipe '\PIPE\111'              */
/* Then it launches two child processes with the 1,2 parm using RbExecPgm    */
/* Main process puts the pipe in the listening state using CONNECT 'CO'      */
/* It reads from the pipe and writes to it. (Blocking read and write).       */
/* Reconnects pipe to read from the second client.                           */
/* It reads from the pipe and writes to it. (Blocking read and write).       */
/* Finally it disconnects from the pipe and closes it.                       */
/*                                                                           */
/* The 1st child process uses CALL (transacts) to open pipe, write, read     */
/* and close the pipe.                                                       */
/*                                                                           */
/* The 2nd child process opens the pipe, waits till it's not busy and        */
/* writes to it. Then it reads from the pipe closes it and exits.            */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
if (arg(1) == '') then do /* Main process */
  rc = RbNPipe('CR', '\PIPE\111', 'h', 1, TDW); /* Create message pipe byte mode */
  rc = RbNPipe('SET', h, R); /* Set message mode */
  say "<Parent> Starting two child processes ..."
  rc = RbExecPgm("cmd.exe /c NAMEPIPE 1", Ret, 1);
  rc = RbExecPgm("cmd.exe /c NAMEPIPE 2", Ret, 1);
  rc = RbNPipe('CO', h);

  /************ Read from one child ************/
  say "<Parent> Reading from pipe ..."
  rc = RbRead(h, 'data', 5);
  say "<Parent> Received:" data
  say "<Parent> Writing to pipe 'ABCDEFGH' ..."
  rc = RbWrite(h, 'ABCDEFGH');

  /************ Read from another child ************/
  call RbSleep 2000                       /* To create Pipe busy condition */
  rc = RbNPipe('RE', h);                  /* Make pipe ready.  Remove BUSY */
  say
  say "<Parent> Pipe reconnected"
  say "<Parent> Reading from pipe ..."
  rc = RbRead(h, 'data', 5);
  say "<Parent> Received:" data
  say "<Parent> Writing to pipe 'OPQRSTUV' ..."
  rc = RbWrite(h, 'OPQRSTUV');
  rc = RbSleep(5000);
  rc = RbNPipe('D', h);
  rc = RbClose(h);
  exit
  end
else if (arg(1) == '1') then do
/******************************************/
/* Child 1                                */
/******************************************/
  say '<Child 1> writing to pipe 54321  ... and reading from pipe ...'
  rc = RbNPipe(CALL, '\PIPE\111', '54321', 'data', 100, 3000);
  say '<Child 1> received ' data
   end
else if (arg(1) == '2') then do
/******************************************/
/* Child 2 (Transaction mode)             */
/******************************************/
   do i=1
     rc=RbOpen('\PIPE\111', 'h', 'COTU');
     if (rc = 231) then do                  /* If pipe is busy */
       call RvTTY "Busy..."
       call RbNPipe WAIT, '\PIPE\111', 200
       end
     else if rc=0 then leave
     else exit rc;
     end
   say '<Child 2> writing to pipe  09876  ...'
   rc = RbWrite(h, '09876');
   say '<Child 2> reading from pipe ...'
   rc = RbRead(h, 'data', 8);
   say '<Child 2> received ' data
   rc = RbClose(h);
  end
