/***********************************************************/
/* FILE:     QFILELST.CMD                                  */
/* FUNCTION: RbQFileList                                   */
/*                                                         */
/* Lists the OS/2 device drivers with the extension DRV    */
/* 1. Finds the boot drive using RbQSysInfo                */
/* 2. Converts boot drive number to letter using RbDiskN2C */
/* 3. Uses RbQFileList to issue search similar to          */
/*    the command "DIR \OS2\*.DRV /S" to look for          */
/*    files only (excluding directories) and recursing     */
/*    into subdirectories of the OS/2 directory.           */
/* 4. Displays all the found file names in the DO loop.    */
/***********************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
call RbQSysInfo("S");               /* Get system info including boot drive */
drivers = RbDiskN2C(S.BootDriveNumber)":\OS2\*.DRV" /* OS/2 drivers */
say 'Please wait, searching for device drivers.'
rc = RbQFileList(drivers, qs, F, R);     /* List files (no dirs) and recurse */
                                         /*  into subdirectories             */
if (rc = 0) then do i=1 to qs.0
say qs.FullFileName.i qs.Attrib.i qs.Size.i qs.AllocSize.i qs.Month.i'/'qs.Day.i'/'qs.Year.i qs.Hour.i':'qs.Min.i':'qs.Sec.i
end
