/*************************************************************/
/* FILE:     QPATHINF.CMD                                    */
/* FUNCTION: RbQPathInf                                      */
/*                                                           */
/* Querying file attributes.                                 */
/*                                                           */
/* Requests to enter a file name.                            */
/* Obtains and displays file attributes like date, size,     */
/* archived, hidden, etc. attributes and the full file name. */
/*************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
say 'Enter file or directory name: '
pull fname .
rc1 = RbQPathInfo(fname, "qs.");
if (rc1 = 0) then do
say "Last write date & time" qs.Month'/'qs.Day'/'qs.Year qs.Hour':'qs.Min':'qs.Sec
say "Size = " qs.Size
say "Allocated Size = " qs.AllocSize
say "File Attributes ArchivedDirSystemHiddenRo = " qs.Attrib
say "FullName = " qs.FullFileName
end
else if (rc1 = 2) then say 'File "'fname'" does not exist.'
else if (rc1 = 3) then say 'Path "'fname'" does not exist.'
else say 'RC=' rc1
