/********************************************************************/
/* FILE:     QSYSINFO.CMD                                           */
/* FUNCTION: RbQSysInfo                                             */
/*                                                                  */
/* Obtains and displays miscellaneous system information including: */
/* OS/2 boot drive letter, OS/2 version, amount of physical memory, */
/* number of processors, foreground session information and other.  */
/********************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
rc1 = RbQSysInfo("qs.");
say 'Maximum length, in bytes, of a path name                         = ' qs.MaxPathLength
say 'Maximum number of text sessions                                  = ' qs.MaxTextSessions
say 'Maximum number of PM sessions                                    = ' qs.MaxPmSessions
say 'Maximum number of DOS sessions                                   = ' qs.MaxVdmSessions
say 'Dynamic priority variation flag (0-absolute priority,1-dynamic)  = ' qs.DynPriVariation
say 'Maximum wait in seconds                                          = ' qs.MaxWait
say 'Minimum time slice in milliseconds                               = ' qs.MinSlice
say 'Maximum time slice in milliseconds                               = ' qs.MaxSlice
say 'Memory page size in bytes                                        = ' qs.PageSize
say 'Value of a 32-bit, free-running millisecond counter              = ' qs.MsCount
say 'Low-order 32 bits of the time in seconds since January 1, 1970   = ' qs.TimeLow
say 'High-order 32 bits of the time in seconds since January 1, 1970  = ' qs.TimeHigh
say 'Total number of bytes of resident memory in the system           = ' qs.TotResMem
say 'Maximum memory bytes can be allocated by all processes           = ' qs.TotAvailMem
say 'Max memory bytes this process can allocate in private arena      = ' qs.MaxPrivateMem
say 'Max memory bytes this process can allocate in shared arena       = ' qs.MaxSharedMem
say 'Timer interval in tenths of a millisecond                        = ' qs.TimerInterval
say 'Maximum length, in bytes, of one component in a path name        = ' qs.MaxCompLength
say 'Number of processors in the machine                              = ' qs.NumProcessors
say '*********************************************************************'
say 'Drive from which the system was started (1 means drive A, 2 - B) = ' qs.BootDriveNumber
say 'Total number of bytes of physical memory in the system           = ' qs.TotPhysMem
say 'Major version number                                             = ' qs.VersionMajor
say 'Minor version number                                             = ' qs.VersionMinor
say 'Revision number                                                  = ' qs.VersionRevision
say 'Session ID of the current foreground full-screen session         = ' qs.FgFullScrSesId
say 'Process ID of the current foreground process                     = ' qs.FgProcessId
