/********************************************************************/
/* FILE:     QSYSTEM.CMD                                            */
/* FUNCTION: Display system information and disk utilization        */
/********************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

rc = RvMode('GET', screen);               /* Get window size */
mode = 'S'

YA = RvMakeAttr('RGH','')
GA = RvMakeAttr('RGB','')

call RvCls
say
/****************************************************/
/* Get system info                                  */
/****************************************************/
call  RbQSysInfo "qs."
call  RvTTY "OS/2                  ", YA
call  RvTTYL 'Ver' substr(qs.VersionMajor,1,1)'.'substr(qs.VersionMinor,1,1)||,
             ' Rev' qs.VersionRevision ||,
             ' started from drive' RbDiskN2C(qs.BootDriveNumber),GA
call  RvTTY "Physical memory:      ", YA
call  RvTTYL (qs.TotPhysMem+1048575)%1048576'MB ', GA
/****************************************************/
/* Get device configuration                         */
/****************************************************/
call RbQDevConfig "qd"
call  RvTTY "Physical hard drives: ", YA
call  RvTTYL qd.HardDrives , GA
call  RvTTY "Diskette drives:      ", YA
call  RvTTYL qd.DisketteDrives  , GA
call  RvTTY "Parallel ports:       ", YA
call  RvTTYL qd.ParallelPorts   , GA
call  RvTTY "Serial ports:         ", YA
call  RvTTYL qd.SerialPorts   , GA
call  RvTTY "Math coprocessor      ", YA
if qd.Coprocessor = '1' then
  call  RvTTYL "Installed", GA
else
  call  RvTTYL "Not installed", GA

LocD = ''
NetD = ''
CDR = ''
lcnt = 0;

disks = RbQDisks()
do i=1 to length(disks)
  dl = substr(disks,i,1)
  dn = RbDiskC2N(dl)
  valid = CheckValidDrive(dl)
  select
    when valid = 'LOCAL' then do
      LocD = LocD||dl' '
      lcnt = lcnt + 1
      call RbQFSInfo dn, "qv."
      Disk.lcnt     = 'DISK 'dl':'
      VolLabel.lcnt = qv.VolLabel
      TotalBytes.lcnt =  qv.TotalBytes
      FreeBytes.lcnt  =  qv.FreeBytes
      end
    when valid = 'NETWORK' then NetD = NetD||dl' '
    when valid = 'CD-ROM' | valid = 'NOTREADY' then CDR = CDR||dl' '
    otherwise nop;
    end
  end
call  RvTTY "Local logical drives: ", YA
call  RvTTYL LocD   , GA
call  RvTTY "Network drives:       ", YA
call  RvTTYL NetD   , GA
call  RvTTY "CD-ROM  drives:       ", YA
call  RvTTYL CDR    , GA
do j=1 to lcnt
  call  RvTTY left(disk.j,22), YA
  call RvTTYL left('Label:' VolLabel.j,20),
              left('Size:' TotalBytes.j%1048576'MB', 16),
              left('Free:' FreeBytes.j%1048576'MB', 16), GA
  end
/****************************************************/
/* Display Adapter info                             */
/****************************************************/
call  RvGetConfig(da)
select
  when da.adapter =  0    then adapter = 'Monochrome   '
  when da.adapter =  1    then adapter = 'CGA          '
  when da.adapter =  2    then adapter = 'EGA          '
  when da.adapter =  3    then adapter = 'VGA          '
  when da.adapter =  7    then adapter = '8514a        '
  when da.adapter =  8    then adapter = 'Imageadapter '
  when da.adapter =  9    then adapter = 'XGA          '
  when da.adapter =  10   then adapter = 'SVGA         '
  otherwise                    adapter = '             '
  end
call  RvTTY "Display Adapter:      ", YA
if datatype(da.memory) = 'NUM'
then call  RvTTYL adapter  'Adapter Memory: ' da.memory%1048576'MB'  , GA
else call  RvTTYL adapter  'Adapter Memory: ' 'cannot be determined'  , GA

/****************************************************/
/* Keyboard                                         */
/****************************************************/
call RkGetStatus kb
if kb.ECHO = '1' then echo = ON
  else echo = OFF
if kb.ASCII = '1' then ascii = ASCII
  else ascii = BINARY
call  RvTTY "Keyboard:             ", YA
call  RvTTYL 'Echo' echo ' Mode' ascii ' CodePage' RkCodePage() , GA

/****************************************************/
/* Mouse info                                       */
/****************************************************/
rc = RmOpen('h')
rc = RmGetNum(h,mn)
rc = RmClose(h);
call  RvTTY "Mouse:                ", YA
call  RvTTYL mn.Buttons buttons, GA

/****************************************************/
/* LIBPATH                                          */
/****************************************************/
ConfigSys = RbDiskN2C(qs.BootDriveNumber)||':\CONFIG.SYS'
rc = RbReadText(ConfigSys, line);
/******************************************/
do i=1 to line.0
  parse upper var line.i uline
  if substr(uline,1,8) = 'LIBPATH=' then do
    call  RvTTY "LIBPATH=              ", YA
    call  RvTTYL substr(uline,9), GA
    leave i
    end
  end
exit 0

/****************************************************/
/* Check if valid drive for installation            */
/*   Returns LOCAL, FLOPPY, NETWORK, INVALID,       */
/*           NOTREADY, CD-ROM                       */
/****************************************************/
CheckValidDrive: Procedure
  parse arg dl
  if length(dl) <> 1 then return 'INVALID'
  dn = RbDiskC2N(dl)
  call RbError 2                            /* Disable error pop-up for CD_rom */
  select
    when (dn < 3) then valid = 'FLOPPY'
    when RbQDevice(dl":") = 'REMOTE' then valid = 'NETWORK'
    when RbQDevice(dl":") = '' then valid = 'NOTREADY'
    otherwise
      rc = RbQFSInfo(dn, S);
      if rc <> 0 then valid = 'NOTREADY'
      else if (S.FreeBytes = 0) then valid = 'CD-ROM'
      else valid = 'LOCAL'
    end
call RbError 1
return valid
