/******************************************************************/
/* FILE:     QUEUE.CMD                                            */
/* FUNCTION: RbQueue                                              */
/*                                                                */
/* Using queues.                                                  */
/* This command file runs in main and child processes.            */
/* In main process it's called without parameters and             */
/*   1. Launches QUEUE.CMD with CHILD parameter as                */
/*      a child process using RbExecPgm("cmd.exe /c queue child") */
/*   2. Creates the message queue "\QUEUES\44444"                 */
/*   3. Reads from the queue till the string "QUIT" is received.  */
/*   4. When "QUIT" has been received it displays the numbers     */
/*      of messages in queue and peeks and displays each          */
/*      remaining queue message without removing it from the queue*/
/*   5. Purges the queue deleting all the messages.               */
/*   6. Destroys the queue.                                       */
/* The child process does the following:                          */
/*   1. Opens the queue to obtain the queue handle and use it.    */
/*   2. Request from the user to enter a line and writes it       */
/*      to the queue three times.                                 */
/*   3. When "QUIT" has been entered closes the queue and exits   */
/*      the child process.                                        */
/******************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

if (arg(1) == '') then do /* Main process */
  rc = RbExecPgm("cmd.exe /c queue child ", Ret, 1);
  say '<Main>rc =' RbQueue("CR","\QUEUES\44444", "Qh");
  say '<Main>qh='qh
  say '<Main>Ready to receive...'
  do forever

    say '<Main>rcRead =' RbQueue(Read, Qh, Rd, 0);
    say '<Main Read>pid ev el pri dat' Rd.PID Rd.EventCode Rd.Element Rd.Priority Rd.Data
    if Rd.Data="QUIT" then leave
    call RbSleep 200

    rc = RbQueue(QUERY, Qh,'Cnt')
    say '<Main>Queue has ' Cnt 'message(s).'

    if (rc = 0 & Cnt>0) then do
      do i=0 to cnt-1
        call RbQueue PEEK, Qh, Rd, i
        say '<Main Peek> pid event elem priority data'
        say '<Main Peek>' Rd.PID Rd.EventCode Rd.Element Rd.Priority Rd.Data
        end
      end
      call RbQueue PURGE, Qh /* Delete all the rest */
    end
  call RbSleep 1000
  say '<Main>Closing queue ...'
  call RbQueue D, Qh
  say '<Main>Exiting ...'
  exit
  end


/******************************************/
/* Child process                          */
/******************************************/
rc = RbQueue("Op","\QUEUES\44444", "Qh");
do forever
  say '<Child> Enter line'
  parse upper pull ans .
  say '<Child> SentRc =' RbQueue(Write, Qh, ans);
  say '<Child> SentRc =' RbQueue(Write, Qh, "Duplicate "ans);
  say '<Child> SentRc =' RbQueue(Write, Qh, "Duplicate "ans);

  if ans='QUIT' then leave;
  end
rc = RbQueue(CLOSE,Qh);
say '<Child> Queue closed Rc='rc
