/*****************************************************************************/
/* FILE:     READTEXT.CMD                                                    */
/* FUNCTION: RbReadText                                                      */
/*                                                                           */
/* Read an entire text (ASCII) file into an array of REXX variables.         */
/* Displays LIBPATH list of directories.                                     */
/*                                                                           */
/* Uses RbQSysInfo and RbDiskN2C to find the OS/2 boot drive and the         */
/* full path to the active CONFIG.SYS file.                                  */
/*                                                                           */
/* Read the entire config.sys file into the array T.i of rexx variables.     */
/* Find line containing the string "LIBPATH" searching through the array T.i */
/* Display this line and exit.                                               */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
call RbQSysInfo("S");               /* Get system info including boot drive */
Cfg = RbDiskN2C(S.BootDriveNumber)":\CONFIG.SYS" /* Config sys full path name */

rc=RbReadText(cfg, t);
say 'Config sys contains ' t.0 'lines'
do i=1 to t.0
  parse upper value t.i with line
  if (pos(LIBPATH, line) <> 0) then do
    say t.i
    leave
    end
  end
