/*****************************************************************************/
/* FILE:     SESSIONS.CMD                                                    */
/* FUNCTION: RbStartSes, RbSelSes                                            */
/*                                                                           */
/* Session manipulation.                                                     */
/*                                                                           */
/* This command file is executed in the parent (no parms) and child          */
/* session invoked as SESSIONS  child.                                       */
/*                                                                           */
/* The child session does nothing but displays 120 times (once a second)     */
/* <Child>  Exiting session in' i 'seconds and then exits if not interrupted.*/
/*                                                                           */
/* The parent session first starts the child session in the background with  */
/* the title "Child StartSes Maximized"(RbStartSes). User can see this title */
/* in the window switch list using CTRL-ESC key combination.                 */
/*                                                                           */
/* The parent session makes the child session non-selectable son its         */
/* title is no more displayed in the window switch list.  Then it makes      */
/* the child session selectable again using RbSetSes.                        */
/*                                                                           */
/* Then the parent session brings its child session to foreground for 10 sec */
/* and then brings itself to the foreground so child session goes to the     */
/* background using RbSelectSes.                                             */
/*                                                                           */
/* Finally the parent session stops the child session using RbStopSes.       */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

if (arg(1) = '') then do
  /******************************************/
  /* Parent session                         */
  /******************************************/
  parse source . . FullPathName .            /* Get this file's full name */
  rc = RbStartSes('cmd.exe /c "'FullPathName' child"', 'SesId', 2, 2, C, B, "Child StartSes Maximized")
  if (rc <> 0) then do
    say "Cannot start session Rc = " rc
    exit rc
    end
  say '<Parent> Child session SessId='SesId 'started'
  say '<Parent> Child session is selectable from window switch list "CTRL-ESC"'
  call RbSleep 10000
  say '<Parent> Making child nonselectable from window switch list "CTRL-ESC"'
  call RbSetSes SesId, 2, 0
  call RbSleep 10000
  say '<Parent> Making child selectable from window switch list "CTRL-ESC"'
  call RbSetSes SesId, 1, 0
  call RbSleep 10000

  say '<Parent> Bringing child to foreground for 10 seconds.'
  call RbSelectSes SesId
  call RbSleep 10000
  say '<Parent> Bringing parent (itself) to foreground for 10 seconds'
  call RbSelectSes 0
  call RbSleep 10000
  say '<Parent> Stopping the child in 10 seconds.'
  call RbSleep 10000
  call RbStopSes 0, SesId
  say '<Parent> Child has been stopped.'

  exit
  end

do i=120 to 0 by -1
  say '<Child>  Exiting session in' i 'seconds'
  call RbSleep 1000
  end
