/*****************************************************************************/
/* FILE:     SETDATE.CMD                                                     */
/* FUNCTION: RbSetDate                                                       */
/*                                                                           */
/* Requests USER to enter a new date like 01 31 1996 (Jan 31, 1996)          */
/* Preserves the date                                                        */
/* Sets the date                                                             */
/* Uses REXX Date() build in function to display the new date                */
/* Restores the date                                                         */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
say "Enter mm dd yyyy (after Jan 1, 1980)"
pull mm dd yyyy
RealDate = Date('S');                     /* Preserve the date          */
rc =  RbSetDate(mm,dd,yyyy);              /* Set the specified date     */
if (rc <> 0) then do;
  say "The specified date '"mm"/"dd"/"yyyy"' cannot be set."
  say "mm or dd is out of range or year is less then 1980."
  end
say Date('L');                            /* Display the new date       */
call RbSetDate substr(RealDate,5,2), substr(RealDate,7), substr(RealDate,1,4)
say Date('L');                            /* Display the restored date  */
