/*****************************************************************************/
/* FILE:     SETPRIOR.CMD                                                    */
/* FUNCTION: RbSetPriority                                                   */
/*                                                                           */
/* Setting a process priority.                                               */
/*                                                                           */
/* This command file is running three times as pared, child1 and child2.     */
/*                                                                           */
/* Parents sets first a higher priority for the child1 and lower for child2  */
/* Parents sets then  a higher priority for the child2 and lower for child1  */
/* Then it sets equal priority for the child 1 and child 2                   */
/* Then it sets a little bit higher priority for the child 2                 */
/* Finally it terminates children                                            */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

if (arg(1) = '') then do
  /******************************************/
  /* Parent process                         */
  /******************************************/
  parse source . . FullPathName .            /* Get this file's full name */
  Say 'First child 1 has higher priority and should run faster, then child 2'
  Say 'Then both are the the same, and finally child 2 is a little faster.  '

  call RbSleep 3000
  call RbExecPgm 'CMD.EXE /c "'FullPathName' 1"', ret1, 1
  call RbExecPgm 'CMD.EXE /c "'FullPathName' 2"', ret2, 1

  rc = RbSetPriority(0, 2, 0, ret1.PID);  /* Child 1 Regular   Fast */
  rc = RbSetPriority(0, 1, 0, ret2.PID);  /* Child 2 Idle-Time Slow */

  call RbSleep 20000

  rc = RbSetPriority(0, 1, 0, ret1.PID);  /* Child 1 Idle-Time Slow */
  rc = RbSetPriority(0, 2, 0, ret2.PID);  /* Child 2 Reqular   Fast */

  call RbSleep 20000

  rc = RbSetPriority(0, 1, 0, ret1.PID);  /* Child 1 Idle-Time Slow */
  rc = RbSetPriority(0, 1, 0, ret2.PID);  /* Child 2 Idle-Time Slow */

  call RbSleep 20000

  rc = RbSetPriority(0, 1, 4, ret1.PID);   /* Child 1 Idle-Time Slower   */
  rc = RbSetPriority(0, 1, 5, ret2.PID);   /* Child 2 Idle-Time Slow */

  call RbSleep 40000

  say 'Killing children'
  call RbKillProcess 0, ret1.PID
  call RbKillProcess 0, ret2.PID
  exit
  end


/******************************************/
/* Child 1 or 2                           */
/******************************************/
call RbSleep 10                           /* Give time to initialize */
do i=1 to 15000
  say '<Child_'arg(1)'>' i
  end
