/*****************************************************************/
/* FILE:     SETTIME.CMD                                         */
/* FUNCTION: RbSetTime                                           */
/*                                                               */
/* Setting system time.                                          */
/*                                                               */
/* Request user to enter new time to set.                        */
/* Preserve old (correct) time.                                  */
/* Set new time entered by user and display it.                  */
/* Restore preserved time value and display the current time.    */
/*****************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
say 'Enter new time: HH MM SS '
pull h m s
parse value time() with hh':'mm':'ss      /* Preserve old time */
call RbSetTime h, m, s                    /* Set new time      */
say 'New time ' time() 'has been set.'    /* Obtain and display new time */
call RbSetTime hh, mm, ss                 /* Restore time      */
say 'Original time ' time() 'has been restored.' /* Display current time */
