/*****************************************************************************/
/* FILE:     SHAREMEM.CMD                                                    */
/* FUNCTION: RbSharedMem                                                     */
/*                                                                           */
/* Using shared memory.                                                      */
/*                                                                           */
/* This command file is running twice: in parent and child sessions.         */
/* Parent is started without arguments.                                      */
/* Assigns  value "1111111" to the shared memory segment "\SHAREMEM\TEST1"   */
/* Retrieves the value of the shared memory segment "\SHAREMEM\TEST1" into   */
/*  the REXX variable V and displays it.                                     */
/* Starts its child session (same command file with a parameter "child").    */
/* Waits 10 seconds giving the child time to run.                            */
/* Releases the shared memory.  The shared memory is automatically alloca-   */
/*  ted by the initial RbSharedMem(Put, ) call.                              */
/* Exits the parent session.                                                 */
/*                                                                           */
/* CHILD SESSION.                                                            */
/* Gets the memory value into variable CHILDV and displays it.               */
/* Waits three seconds and exits.                                            */
/*                                                                           */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

if (arg(1) = '') then do
  parse source . . FullPathName .            /* Get this file's full name */
  say '<Parent> Writing to shared memory the value 1111111'
  rc = RbSharedMem(Put, "\SHAREMEM\TEST1", "1111111");
  say '<Parent> Reading from shared memory into variable V'
  rc = RbSharedMem(Get, "\SHAREMEM\TEST1", 'v');
  say '<Parent> Variable V='v
  say '<Parent> Starting child '
  rc = RbStartSes('cmd.exe /c "'FullPathName' child"', 'SesId', 2, 2, C, F,,
                  "Child ShareMem")
  say '<Parent> Waiting 10 seconds for child to proceed'
  call RbSleep 10000
  rc = RbSharedMem(FREE, "\SHAREMEM\TEST1");
  exit
  end
say '<Child> Reading shared memory into variable ChildV'
rc = RbSharedMem(Get, "\SHAREMEM\TEST1", 'ChildV');
say '<Child> ChildV='ChildV
call RbSleep 3000
exit
