/*****************************************************************************/
/* FILE:     Get subdirectory space map                                      */
/* FUNCTION: Get subdirectory sizes that exceed 2% of allocated size         */
/*           Skips all the subdirectories less than 2%                       */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

YA = RvMakeAttr('RGH','')
GA = RvMakeAttr('RGB','')
do dd=1
  call RvCls
  say
  call RvTTYL 'Enter disk letter or any other character to exit', GA
  call RkGetChar 'W', 'S'
  parse upper var S.char DL
  line = 2
  if ( dl >= 'A' & dl <= 'Z')  then do
    dn = RbDiskC2N(DL)
    if 0 <> RbQFSInfo(dn, 'Vol') then iterate dd
    if 0 <> RbQFileList(dl':\*.*', 'dirs', 'D') then iterate dd
    do i=1 to dirs.0
      if substr(dirs.FullFileName.i,4,1) = '.' then iterate
      size = RbQSubdirSize(dirs.FullFileName.i)
      if size > ( Vol.TotalBytes * 0.02) then do
        pct = right(size * 100 % Vol.TotalBytes, 2, 0)
        call RvWriteStr left(dirs.FullFileName.i,25) pct'%',
                        , line, 0, GA
        call RvLine 1, 'H', 30, line, pct/2, YA
        line = line + 1
        end
      end
    end
  else
    exit 0
  call RvWriteStr 'Done, enter any key', line, 0, GA
  pull .
  call RkFlush
  end
exit 0
