/*****************************************************************************/
/* FILE:     SVOLLAB.CMD                                                     */
/* FUNCTION: RbSetVolLabel                                                   */
/*                                                                           */
/* Setting new volume label.  Is recommended to use the floppy disk while    */
/* running this command file. (Specify disk letter A or B)                   */
/*                                                                           */
/* Request to enter the disk letter and its new label.                       */
/* Uses  RbDiskC2N to convert the disk letter to the disk number because     */
/*  the following functions use disk numbers as a parameter.                 */
/* Queries and displays old volume label using RbQFSInfo.                    */
/* Sets the new volume label.                                                */
/* Queries and displays new volume label using RbQFSInfo.                    */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
say 'Enter disk letter and volume label: A Label'
pull disk label
parse upper value substr(disk,1,1) with vol

disknum = RbDiskC2N(vol)
if (disknum = 0) then do
  say 'Invalid disk' disk
  exit
  end
call RbQFSInfo disknum, "qs."
say 'Old volume Label = '  qs.VolLabel
call RbSetVolLabel disknum, label
call RbQFSInfo disknum, "qs."
say 'New volume Label = '  qs.VolLabel
