/*****************************************************************************/
/* FILE:     THREADS.CMD                                                     */
/* FUNCTION: RbBeginThread, RbSuspendThread, RbWaitThread, RbKillThread      */
/*                                                                           */
/* Thread manipulation functions.                                            */
/*                                                                           */
/* This command file is executed in two threads: main and child started by   */
/* the main thread: RbBeginThread("THREADS.CMD a bb ccc","RUN", 'TID');      */
/*                                                                           */
/* MAIN THREAD:                                                              */
/* Starts the second thread using RbBeginThread                              */
/* Waits for 3 seconds giving the second thread the opportunity to run alone.*/
/* Suspends the second thread. RbSuspendThread                               */
/* Resumes the second thread using RbResumeThread                            */
/* Waits for the second thread to complete.                                  */
/* Starts another thread. RbBeginThread("THREADS.CMD new","RUN", 'TID');     */
/* Waits 1 second and then kills it.                                         */
/* Exits.                                                                    */
/*                                                                           */
/* SECOND and THIRD THREAD                                                   */
/* Ten times with the one second delay displays                              */
/* 2nd thread: Running. Parms:  real parameters and exits.                   */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

if (arg(1) = '') then do /* Main thread */
  rc = RbBeginThread("THREADS.CMD a bb ccc","RUN", 'TID');
  if (rc <> 0) then do
    say 'Main: Error starting thread'
    exit
    end
  TID='0'||tid
  say 'Main: The second thread TID='TID 'has been started.'
  call RbSleep 3000
  say "Main: Suspending the second thread"
  rc = RbSuspendThread(tid)
  say "Main: The second thread suspended rc="rc
  call RbSleep 2000
  say "Main: working"
  call RbSleep 2000
  say "Main: working"
  call RbSleep 2000
  say "Main: Resuming the second thread"
  rc=RbResumeThread(tid)
  say 'Main: Waiting for second thread to complete.'
  rc = RbWaitThread(0, 'tid')
  say 'Main: Thread TID='tid 'ended.'
  rc=RbBeginThread("THREADS.CMD new","RUN", 'TID');
  TID='0'||tid
  say 'Start second thread again rc='rc;
  call RbSleep 3000
  say 'Killing second thread'
  rc=RbKillThread(tid);
  say 'Killed rc='rc
  exit;
  end


/******************************************/
/* Second thread                          */
/******************************************/
do i=1 to 10
  say '2nd thread: Running. Parms:' arg(1)
  call RbSleep 1000
  end
