/*****************************************************************************/
/* FILE:     TIMERCTL.CMD                                                    */
/* FUNCTION: RbStartTimer, RbStopTimer                                       */
/*                                                                           */
/* Starting and stopping timer.                                              */
/*                                                                           */
/* Creates the event semaphore "\SEM32\11111"  using RbEventSem("CReate"...) */
/* Initially the semaphore is RESET.                                         */
/* Starts single interval timer passing it the event semaphore handle.       */
/* Waits for the event semaphore to be posted when the timer goes off.       */
/* Stops the timer                                                           */
/* Starts repeated timer.                                                    */
/* Resets the semaphore                                                      */
/* Waits for the timer to post the semaphore.                                */
/* Resets the semaphore                                                      */
/* Waits for the timer to post the semaphore.                                */
/* Stops the timer.                                                          */
/* Closes the event semaphore                                                */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
trace r

/****************************************************/
/* Create event semaphore in RESET state.           */
/****************************************************/
rc1 = RbEventSem("CReate","\SEM32\11111","h","Reset");

/****************************************************/
/* Single Timer                                     */
/****************************************************/
rc = RbStartTimer(5000, h, "Single", 'ht')
rc1 = RbEventSem("W",h);       /* Wait on semaphore */
say 'Timeout'                  /* We get here when timer posts the semaphore */
rc = RbStopTimer(ht);

/****************************************************/
/* Repeated timer posts semaphore each time it      */
/* goes off.                                        */
/****************************************************/
rc  = RbStartTimer(5000, h, "R", 'ht')
rc1 = RbEventSem("Reset",h);   /* Reset semaphore   */
rc1 = RbEventSem("Wait",h);    /* Wait on semaphore */
say 'Timeout 1'                /* We get here when timer posts the semaphore */
rc1 = RbEventSem("Reset",h);   /* Reset semaphore   */
rc1 = RbEventSem("Wait",h);    /* Wait on semaphore */
say 'Timeout 2'                /* We get here when timer posts the semaphore */
rc = RbStopTimer(ht);

rc1 = RbEventSem("CLose",h);    /* Close the event semaphore */
