/*****************************************************************************/
/* FILE:     UNAMPIPE.CMD                                                    */
/* FUNCTION: RbCreatePipe                                                    */
/*                                                                           */
/* Using unnamed pipe.                                                       */
/*                                                                           */
/* This command file is executed twice: in parent and child processes.       */
/* The parent process starts when UNAMPIPE command without parameters in     */
/* entered from the command line.                                            */
/*                                                                           */
/* PARENT.  Creates unnamed pipe.                                            */
/* Starts child process passing it read and write pipe handles.              */
/* Reads from the pipe and displays the five bytes read.                     */
/* Writes the string 'ABCDEFGH' to the pipe.                                 */
/* Waits 3 seconds for the child process to read data.                       */
/* Closes write and read pipe handles.  They should be closed separately.    */
/* Exits.                                                                    */
/*                                                                           */
/* CHILD.                                                                    */
/* Gets read and write pipe handles as parameters.                           */
/* Writes to the pipe and reads data and displays it.                        */
/* Closes write and read pipe handles.  They should be closed separately.    */
/* Exits.                                                                    */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
parse arg p1 .
if (p1 = '') then do            /* Parent process */
  rc = RbCreatePipe('rh','wh'); /* Create pipe with default pipe size 4K */
  rc = RbExecPgm("cmd.exe /c UNAMPIPE child " rh wh, Ret, 1); /* Start child */
  rc = RbRead(rh, 'data', 5);   /* Get 5 bytes from the child */
  say "<Parent> Received: " data /* Display the received data */
  PData = 'ABCDEFGH'
  say "<Parent> sending" PData
  rc = RbWrite(wh, PData);      /* Write for child */
  call RbSleep 3000             /*  and wait for child to receive */
  call RbClose wh               /* Close write and */
  call RbClose rh               /*  read handles   */
  exit
  end
/******************************************/
/* Child process                          */
/******************************************/
parse arg child rh wh .              /* Get read and write pipe handles */
CData = "12345"
say '<Child> sending ' CData         /* Writing to parent */
rc = RbWrite(wh, CData,  'written'); /* Don't have to open */
say '<Child>' written 'bytes sent.'  /* Writing to parent */
call RbRead rh, 'data', 7            /* Read what parent sends */
say '<Child> Received.' data
call RbClose wh                      /* Close */
call RbClose rh                      /*  handles */
