/*****************************************************************************/
/* FILE:     WAITCHLD.CMD                                                    */
/* FUNCTION: RbWaitChild                                                     */
/*                                                                           */
/* Waiting for the completion of the asynchronous child process.             */
/*                                                                           */
/* WAITCHLD.CMD runs in parent and child processes.                          */
/* <PARENT>                                                                  */
/* Launches child process with the single parm = 'CHILD' asynchronously.     */
/* Waits fro the child process to end.                                       */
/* Displays the result and termination code of the child process.            */
/* <CHILD>                                                                   */
/* Displays three times "<Child> running i"                                  */
/* Exits with the result code 23                                             */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs

if (arg(1) = '') then do
      parse source . . FullPathName .    /* Get this file's full name */
      say '<Parent> launching child'
      call RbExecPgm 'cmd.exe /c "'FullPathName' child"', Ret, 2
      say '<Parent> waiting child to complete'
      call RbWaitChild Ret.PID, Res      /* Wait for child process to end */
      say "<Parent> Child Completed. TermCode = " res.termcode ,
          "Result = "res.rescode
      exit
      end

/******************************************/
/* Child process                          */
/******************************************/
do i=1 to 3
  say '<Child> running ' i
  end
say '<Child> exiting with RC=23'
exit 23
