/*****************************************************************************/
/* FILE:     WRITETXT.CMD                                                    */
/* FUNCTION: RbWriteText                                                     */
/*                                                                           */
/* Creating or replacing an ASCII text file.                                 */
/* Requests permission to overwrite WRITETXT.ASC file in current directory.  */
/* Creates or replaces the file with 10 lines:                               */
/* 111111                                                                    */
/* 222222                                                                    */
/* 333333                                                                    */
/* ...                                                                       */
/* 10101010                                                                  */
/*****************************************************************************/
/* Load REXXBOS functions and make them available  */
call RxFuncAdd 'RxLoadFuncs', 'REXXBOS', 'RxLoadFuncs'
call RxLoadFuncs
s.0 = 10
say 'The file  "WRITETXT.ASC" will be replaced in the current directory'
do until (ans = 'YES' | ans = 'NO')
  say 'To proceed and rewrite the target file enter YES otherwise enter NO'
  parse upper pull ans .
  end
if ans='NO' then exit;
do i=1 to s.0
  s.i = i||i||i||i
  end
rc=RbWriteText('WRITETXT.asc', s);
call RxDropFuncs
